# Vespucci 19.0 Highlights

2023-04-23

### "nearby POI" display

The main map display now supports a "nearby POI" display that can be dragged in to view with a handle in the middle of the bottom menu bar.

The view will include a filtered view of all "POI"s displayed on the current map view. If no explicit filter is set this is limited to objects that have a key with one of
_shop_, _amenity_, _leisure_, _tourism_, _craft_, _office_ or _emergency_. If an explicit filter is set, that is a tag filter or a preset filter, or a mode (_Indoor_ and _C_-mode) is selected that sets a filter the display will display objects that are allowed by the filter. For example if _Indoor_ mode is selected, the display will only show POIs on the currently selected level. 

Tapping an entry in the display will center the map on the object and select it, tapping it a second time (just as on the map display) will start the property editor, in _Tag only_ mode the property editor will start directly as expected. The POI entries are highlighted with the same validation indication as map icons, see [validation styling](https://github.com/MarcusWolschon/osmeditor4android/blob/master/src/main/assets/styles/Color-round.xml#L39).

If the Vespucci display is _locked_ tapping an icon in the POI display will start the _info_ modal.

Tip: on devices with small screens dragging the divider up might be a bit tricky as multiple areas that respond to touch input overlap in the closed position, try temporarily hiding the background layer to make this easier. 

### Overpass API support

We now support directly querying an Overpass API server (a non-standard instance can be set in the _Advanced preferences_). Note that to be valid OSM data that Vespucci can use for editing you need to include object meta data and all nodes referenced by ways.

To make this easier to use, similar to Overpass Turbo, you can generate Overpass queries from JOSM filter/search language. See [Object search](http://vespucci.io/tutorials/object_search/).

### Support for external measurement apps

We now support external measuring apps for setting the values of suitable fields in the property editor. For example if you have _StreetMeasure_ installed it will be started automatically if you click on a corresponding field, for example _Width_, and the measurements will be added as values.

Originally we had intended to add support for Bosch laser range finders for this release, however Bosch licenses its SDK for these devices on very restrictive terms that do not allow public distribution of apps that utilize it, even if the functionality is encapsulated in a closed source interface app. As Bosch was not willing to even consider changing these terms, adding support isn't possible for now. 

If you have, or believe you can produce, a clean room reverse engineered specification of the Bosch protocol please feel free to get in contact with us.  

### Support for displaying preset label fields 

We now support text labels from the presets, this is helpful to explain details or give a context to fields. As these can be annoyingly large on devices with smaller screens, support can be turned off in the _Advanced preferences_.

### Imagery alignment function moved to layer dialog

The imagery alignment for a layer is now started from the respective entry in the layer modal. This allows all types of tile based imagery layers to be adjusted, not just the top background layer. The mode has been changed to be more in line with our current UI: clicking the back button will abort the process, click the checkbox will apply the current alignment changes.

## Miscellaneous

- Add render natural=glacier
- Add function to go to start/end of selected way
- Add an autosave mechanism for GPX tracks
- Add exit layer modal directly for GPX play back operations
- Add support adding relations in the EditRelationMembers action mode
- Add validate unconnected end nodes of waterways
- Add make search result dialog horizontally scrollable
- Add default rendering for linear barriers, specific for retaining_wall
- Add info modal for GPX layers
- Add support to presets for list_entry sequences in chunks
- Add support selection of segment for the new way when splitting in all modes
- Add removing the text from an not uploaded note will now remove the comment

# Upgrading from previous versions

* As the saved state file has changed you should upload any pending changes before updating.

# Known problems

* The documentation is out of date.
* For other known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)
